package data.scripts.everyframe;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.awt.Color;
import java.util.List;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ExcelsiorPlugin extends BaseEveryFrameCombatPlugin {

    private static final Color COLOR_1 = new Color(255, 150, 200);
    private static final Color COLOR_2 = new Color(255, 100, 150);
    private static final Color COLOR_3 = new Color(180, 60, 120);
    private static final Vector2f ZERO = new Vector2f();

    private CombatEngineAPI engine;

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (engine == null) {
            return;
        }

        if (engine.isPaused()) {
            return;
        }

        List<DamagingProjectileAPI> activeProjectiles = engine.getProjectiles();
        for (DamagingProjectileAPI projectile : activeProjectiles) {
            if (projectile.getWeapon() == null || projectile.getSource() == null || projectile.getProjectileSpecId() == null ||
                !projectile.getProjectileSpecId().contentEquals("swp_excelsiorcannon_shot")) {
                continue;
            }

            ShipAPI ship = projectile.getSource();
            if (ship.getFluxTracker().getCurrFlux() >= 7500f) {
                engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_75", projectile.getLocation(), projectile.getFacing(),
                                       ship.getVelocity());

                for (int i = 0; i < 25; i++) {
                    float distance = (float) Math.random() * 15f;
                    float size = (float) Math.random() * 8f + 8f;
                    float angle = (float) Math.random() * 270f - 135f;
                    Vector2f spawn_location = MathUtils.getPointOnCircumference(projectile.getLocation(), distance, (angle + projectile.getFacing()));
                    float duration = (float) Math.random() * 0.25f + 0.25f;
                    float speed = 20f * distance / duration;
                    Vector2f particle_velocity = MathUtils.getPointOnCircumference(ship.getVelocity(), speed, angle + projectile.getFacing());
                    engine.addHitParticle(spawn_location, particle_velocity, size, 1f, duration, COLOR_1);
                }
                for (int i = 0; i < 2; i++) {
                    float angle = (float) Math.random() * 360f;
                    float distance = (float) Math.random() * 40f;
                    Vector2f point1 = MathUtils.getPointOnCircumference(projectile.getLocation(), distance, angle);
                    Vector2f point2 = MathUtils.getPointOnCircumference(projectile.getLocation(), distance + (float) Math.random() * 60f, angle);
                    engine.spawnEmpArc(ship, point1, new SimpleEntity(point1), new SimpleEntity(point2), DamageType.ENERGY, 0f, 0f, 1000f, null, 30f, COLOR_2,
                                       COLOR_1);
                }
                engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 200f, 0.175f);
                engine.addSmoothParticle(projectile.getLocation(), ship.getVelocity(), 400f, 0.5f, 0.125f, COLOR_3);

                RippleDistortion ripple = new RippleDistortion(projectile.getLocation(), ship.getVelocity());
                ripple.setSize(200f);
                ripple.setIntensity(20f);
                ripple.setFrameRate(180f);
                ripple.fadeInSize(0.4f);
                ripple.fadeOutIntensity(0.35f);
                DistortionShader.addDistortion(ripple);

                ship.getFluxTracker().decreaseFlux(125f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_75_fire", 1f, 1f, new Vector2f(projectile.getLocation()), ZERO);
            } else if (ship.getFluxTracker().getCurrFlux() >= 5000f) {
                engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_50", projectile.getLocation(), projectile.getFacing(),
                                       ship.getVelocity());

                for (int i = 0; i < 20; i++) {
                    float distance = (float) Math.random() * 12.5f;
                    float size = (float) Math.random() * 7f + 7f;
                    float angle = (float) Math.random() * 270f - 135f;
                    Vector2f spawn_location = MathUtils.getPointOnCircumference(projectile.getLocation(), distance, (angle + projectile.getFacing()));
                    float duration = (float) Math.random() * 0.2f + 0.2f;
                    float speed = 20f * distance / duration;
                    Vector2f particle_velocity = MathUtils.getPointOnCircumference(ship.getVelocity(), speed, angle + projectile.getFacing());
                    engine.addHitParticle(spawn_location, particle_velocity, size, 1f, duration, COLOR_1);
                }
                for (int i = 0; i < 1; i++) {
                    float angle = (float) Math.random() * 360f;
                    float distance = (float) Math.random() * 30f;
                    Vector2f point1 = MathUtils.getPointOnCircumference(projectile.getLocation(), distance, angle);
                    Vector2f point2 = MathUtils.getPointOnCircumference(projectile.getLocation(), distance + (float) Math.random() * 45f, angle);
                    engine.spawnEmpArc(ship, point1, new SimpleEntity(point1), new SimpleEntity(point2), DamageType.ENERGY, 0f, 0f, 1000f, null, 25f, COLOR_2,
                                       COLOR_1);
                }
                engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 175f, 0.15f);
                engine.addSmoothParticle(projectile.getLocation(), ship.getVelocity(), 350f, 0.4f, 0.1f, COLOR_3);

                ship.getFluxTracker().decreaseFlux(100f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_50_fire", 1f, 1f, new Vector2f(projectile.getLocation()), ZERO);
            } else if (ship.getFluxTracker().getCurrFlux() >= 3000f) {
                engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_30", projectile.getLocation(), projectile.getFacing(),
                                       ship.getVelocity());

                for (int i = 0; i < 15; i++) {
                    float distance = (float) Math.random() * 10f;
                    float size = (float) Math.random() * 6f + 6f;
                    float angle = (float) Math.random() * 270f - 135f;
                    Vector2f spawn_location = MathUtils.getPointOnCircumference(projectile.getLocation(), distance, (angle + projectile.getFacing()));
                    float duration = (float) Math.random() * 0.15f + 0.15f;
                    float speed = 20f * distance / duration;
                    Vector2f particle_velocity = MathUtils.getPointOnCircumference(ship.getVelocity(), speed, angle + projectile.getFacing());
                    engine.addHitParticle(spawn_location, particle_velocity, size, 1f, duration, COLOR_1);
                }
                engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 150f, 0.125f);
                engine.addSmoothParticle(projectile.getLocation(), ship.getVelocity(), 300f, 0.3f, 0.075f, COLOR_3);

                ship.getFluxTracker().decreaseFlux(75f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_30_fire", 1f, 1f, new Vector2f(projectile.getLocation()), ZERO);
            } else if (ship.getFluxTracker().getCurrFlux() >= 1500f) {
                engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_15", projectile.getLocation(), projectile.getFacing(),
                                       ship.getVelocity());

                for (int i = 0; i < 10; i++) {
                    float distance = (float) Math.random() * 7.5f;
                    float size = (float) Math.random() * 5f + 5f;
                    float angle = (float) Math.random() * 270f - 135f;
                    Vector2f spawn_location = MathUtils.getPointOnCircumference(projectile.getLocation(), distance, (angle + projectile.getFacing()));
                    float duration = (float) Math.random() * 0.1f + 0.1f;
                    float speed = 20f * distance / duration;
                    Vector2f particle_velocity = MathUtils.getPointOnCircumference(ship.getVelocity(), speed, angle + projectile.getFacing());
                    engine.addHitParticle(spawn_location, particle_velocity, size, 1f, duration, COLOR_1);
                }
                engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 125f, 0.1f);

                ship.getFluxTracker().decreaseFlux(50f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_15_fire", 1f, 1f, new Vector2f(projectile.getLocation()), ZERO);
            } else if (ship.getFluxTracker().getCurrFlux() >= 500f) {
                engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_5", projectile.getLocation(), projectile.getFacing(),
                                       ship.getVelocity());

                engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 100f, 0.075f);

                ship.getFluxTracker().decreaseFlux(25f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_5_fire", 1f, 1f, new Vector2f(projectile.getLocation()), ZERO);
            } else {
                engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_0", projectile.getLocation(), projectile.getFacing(),
                                       ship.getVelocity());

                ship.getFluxTracker().decreaseFlux(5f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_0_fire", 1f, 1f, new Vector2f(projectile.getLocation()), ZERO);
            }

            engine.removeEntity(projectile);
        }
    }

    @Override
    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }
}
